<?php
/**
 * Child theme functions
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions would be used.
 *
 * Text Domain: oceanwp
 * @link http://codex.wordpress.org/Plugin_API
 *
 */

/**
 * Load the parent style.css file
 *
 * @link http://codex.wordpress.org/Child_Themes
 */
function oceanwp_child_enqueue_parent_style() {
	// Dynamically get version number of the parent stylesheet (lets browsers re-cache your stylesheet when you update your theme)
	$theme   = wp_get_theme( 'OceanWP' );
	$version = $theme->get( 'Version' );
	// Load the stylesheet
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'oceanwp-style' ), $version );
	
}
add_action( 'wp_enqueue_scripts', 'oceanwp_child_enqueue_parent_style', 99 );


/* GLOBAL BUTTON STYLES*/
function replace_button_styles() {
    return [
        'main-color-btn' => 'Main Color Button',
        'accent-color-btn' => 'Accent Color Button',
		'gray-btn' => 'Gray Button',
        'white-btn' => 'White Button',
    ];
}
add_filter( 'tmx_set_button_styles', 'replace_button_styles', 10 );


function replace_button_sizes() {
    return [
        'square-small-btn' => 'Square Small',
        'square-large-btn' => 'Square Large',
		'pill-small-btn' => 'Pill Small',
		'pill-large-btn' => 'Pill Large',
    ];
}
add_filter( 'tmx_set_button_sizes', 'replace_button_sizes', 10 );

/* REMOVE DEFAULT BUTTON STYLESHEET */
function should_enqueue_default_styles() {
    return false;
}
add_filter( 'tmx_should_enqueue_default_stylesheet', 'should_enqueue_default_styles', 10 );



/** WebP **/
//** *Enable upload for webp image files.*/
function webp_upload_mimes($existing_mimes) {
    $existing_mimes['webp'] = 'image/webp';
    return $existing_mimes;
}
add_filter('mime_types', 'webp_upload_mimes');

//** * Enable preview / thumbnail for webp image files.*/
function webp_is_displayable($result, $path) {
    if ($result === false) {
        $displayable_image_types = array( IMAGETYPE_WEBP );
        $info = @getimagesize( $path );

        if (empty($info)) {
            $result = false;
        } elseif (!in_array($info[2], $displayable_image_types)) {
            $result = false;
        } else {
            $result = true;
        }
    }

    return $result;
}
add_filter('file_is_displayable_image', 'webp_is_displayable', 10, 2);



// INCLUDE GOOGLE ANALYTICS

add_action('wp_head', 'wpse_43672_wp_head');
function wpse_43672_wp_head(){
    include 'googleanalytics.php';
}

// INCLUDE GOOGLE TAG MANAGER - BODY

function custom_content_after_body_open_tag() {
	include 'gtm-body.php';
}
add_action('wp_body_open', 'custom_content_after_body_open_tag', 1);



// FIX TABLET VIEW IN CUSTOMIZER
function en_customizer_styles() {
 ?>
  <style>
 .preview-tablet .wp-full-overlay-main {
 	width: 768px;
 }
</style>
<?php
}

add_action( 'customize_controls_print_styles', 'en_customizer_styles' );


add_post_type_support( 'page', 'excerpt' );


// ADD CUSTOM FONT TO CUSTOMIZER
function ocean_add_custom_fonts() {
	return array( 'Robinson' ); // You can add more then 1 font to the array!
}
